/* Layout */

#import <Cocoa/Cocoa.h>
#import "MJSConstants.h"

#define MAX_TILES_X 39
#define MAX_TILES_Y 21

#define MAX_LAYERS 16


@interface Layout : NSObject
{
    BOOL layout[MAX_LAYERS][MAX_TILES_X][MAX_TILES_Y];
    int stat_count;
    int stat_layers;
	int lowest_layer;
	int highest_layer;
}

- (id)init;
- (id)initFromAsciiData :(NSData*)layout;
- (id)initFromBinaryData :(NSData*)layout;
- (id)initFromRandom;
- (id)initFromLayout :(Layout*)layout;
- (NSData*)createDataFromLayout;
- (BOOL)tileOn :(int)layer :(int)x :(int)y;
- (id)setTile :(int)layer :(int)x :(int)y :(BOOL)value;
- (void)statLayout;
- (unsigned)count;
- (int)layers;
- (int)lowestLayer;
- (int)highestLayer;
- (BOOL)noOverlap :(int)layer :(int)x :(int)y;
- (void)fastClear;
- (BOOL*)layoutData;

@end
